﻿using System;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business.Utilities;
using VeteransAffairs.Registries.BusinessManager.Utilities;

public partial class Referrals : BasePage
{
    protected void Page_Load(object sender, EventArgs e)
    {
        Session["statusId"] = SessionItemFactory.Create(Request.Params.Get("statusId") ?? "4");

        if (!IsPostBack)
            HiddenFieldClearFlag.Value = "0";
    }

    protected void Source_Selecting(object sender, ObjectDataSourceSelectingEventArgs e)
    {
        
    }

    protected void ReferralView_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewEFRReferrals.SelectedIndex = index;
            int id = Convert.ToInt32(GridViewEFRReferrals.SelectedValue);

            Response.Redirect("referral.aspx?referralId={0}&statusId={1}", id, Helpers.GetStringFromObject(SessionItemValue.Get(Session["statusId"])));
        }
    
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        TextBoxSearchCriteria.Text = string.Empty;
        HiddenFieldClearFlag.Value = "1";
    }

    protected void ButtonOK_Click(object sender, EventArgs e)
    {
        GridViewEFRReferrals.PageIndex = 0;
        HiddenFieldClearFlag.Value = "0";
    }

    public override string TopMenuName()
    {
        return "My Tasks";
    }

    public override string MenuItemName()
    {
        return "EFR REFERRALS";
    }

    public override string AppObjectCode()
    {
        return "EFR REFERRALS";
    }
}
